//=============================================================================
// Balloon subclass for regen balloons, never spawned (on purpose lol!!)
//=============================================================================
class Balloon_regen extends Balloon;

#exec obj load file=..\Textures\PopBalloonsTextures.utx package=PopBalloonsTextures
#exec mesh import mesh=Regen anivfile=Models\Regen_a.3d datafile=Models\Regen_d.3d x=0 y=0 z=0 mlod=0
#exec mesh origin mesh=Regen x=0 y=0 z=0
#exec mesh sequence mesh=Regen seq=All startframe=0 numframes=1
#exec meshmap new meshmap=Regen mesh=Regen
#exec meshmap scale meshmap=Regen x=0.24606 y=0.24606 z=0.49213

/* regen balloons group contains the following balloons:
	- red 		(layers: 10, speed: 1.000000, key: 8)
	- blue		(layers: 15, speed: 1.300000, key: 9)
	- green		(layers: 20, speed: 1.600000, key: A)
	- White		(layers: 30, speed: 2.000000, key: B)
*/

function SetColor()
{
	if ( Health <= 10 )
		{
		MultiSkins[0] = Texture'PopBalloonsTextures.Colors.cRed';
		AirSpeed = BaseSpeed * 1.300000;
		DrawScale = Default.DrawScale * 0.9 * 0.9 * 0.9;
		}
	else if ( Health <= 15 )
		{
		MultiSkins[0] = Texture'PopBalloonsTextures.Colors.cBlue';
		AirSpeed = BaseSpeed * 1.400000;
		DrawScale = Default.DrawScale * 0.9 * 0.9;
		}
	else if ( Health <= 20 )
		{
		MultiSkins[0] = Texture'PopBalloonsTextures.Colors.cGreen';
		AirSpeed = BaseSpeed * 1.500000;
		DrawScale = Default.DrawScale * 0.9;
		}
	else
		{
		MultiSkins[0] = Texture'PopBalloonsTextures.Colors.cWhite';
		AirSpeed = BaseSpeed * 1.600000;
		}
}

defaultproperties
{
	 layers=1
	 speed=1.000000
     AmbientGlow=64
	 Mesh=Mesh'Regen'
     CollisionRadius=24.00000
	 CollisionHeight=24.00000
	 DrawScale=0.300000
}
